/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.xml;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class XmlSource {
    private static Logger log = LoggerFactory.getLogger(XmlSource.class);
    private boolean alreadyRead = false;

    public Document read(SAXReader reader) throws DocumentException, IOException {
        if (this.alreadyRead) {
            throw new IllegalStateException();
        }
        this.alreadyRead = true;
        return this.readImpl(reader);
    }

    public XMLStreamReader getReader(XMLInputFactory inputFactory) throws XMLStreamException {
        if (this.alreadyRead) {
            throw new IllegalStateException();
        }
        this.alreadyRead = true;
        return this.getReaderImpl(inputFactory);
    }

    public void closeSource() {
        if (!this.alreadyRead) {
            throw new IllegalStateException();
        }
        this.closeImpl();
    }

    protected abstract void closeImpl();

    protected abstract Document readImpl(SAXReader var1) throws DocumentException, IOException;

    protected abstract XMLStreamReader getReaderImpl(XMLInputFactory var1) throws XMLStreamException;

    protected abstract void resetImpl() throws XMLStreamException;

    public void reset() throws XMLStreamException {
        this.alreadyRead = false;
        this.resetImpl();
    }

    public Source getJavaxSource() {
        if (this.alreadyRead) {
            throw new IllegalStateException();
        }
        this.alreadyRead = true;
        return this.getJavaxSourceImpl();
    }

    protected abstract Source getJavaxSourceImpl();

    public static XmlSource create(File file) {
        return new FileXmlSource(file);
    }

    public static XmlSource create(InputStream inputStream) {
        return new IsXmlSource(inputStream);
    }

    public static XmlSource create(URL url) {
        return new UrlXmlSource(url);
    }

    public static XmlSource create(Reader reader) {
        return new ReaderXmlSource(reader);
    }

    public static XmlSource create(String xmlContent) {
        return new ReaderXmlSource(new StringReader(xmlContent));
    }

    public static XmlSource create(byte[] xmlContent) {
        return new IsXmlSource(new ByteArrayInputStream(xmlContent));
    }

    private static final class FileXmlSource
    extends XmlSource {
        private final File file;
        private FileInputStream fileInputStream;

        public FileXmlSource(File file) {
            this.file = file;
        }

        @Override
        public Document readImpl(SAXReader reader) throws DocumentException, IOException {
            if (!this.file.canRead()) {
                throw new FileNotFoundException("Cannot read file " + this.file.getAbsolutePath());
            }
            return reader.read(this.file);
        }

        @Override
        protected XMLStreamReader getReaderImpl(XMLInputFactory inputFactory) throws XMLStreamException {
            try {
                this.fileInputStream = new FileInputStream(this.file);
                return inputFactory.createXMLStreamReader(this.file.getAbsolutePath(), new FileInputStream(this.file));
            }
            catch (FileNotFoundException e) {
                throw new XMLStreamException("Cannot read file " + this.file.getAbsolutePath());
            }
        }

        public String toString() {
            return this.file.toString();
        }

        @Override
        protected void closeImpl() {
            try {
                this.fileInputStream.close();
            }
            catch (IOException e) {
                log.error("Failed to close file " + this.file.toString(), e);
            }
        }

        @Override
        protected void resetImpl() throws XMLStreamException {
            try {
                this.fileInputStream.close();
                this.fileInputStream = new FileInputStream(this.file);
            }
            catch (IOException e) {
                throw new XMLStreamException(e);
            }
        }

        @Override
        public Source getJavaxSourceImpl() {
            return new StreamSource(this.file);
        }
    }

    private static final class IsXmlSource
    extends XmlSource {
        private final InputStream inputStream;

        public IsXmlSource(InputStream inputStream) {
            this.inputStream = new BufferedInputStream(inputStream, 262144);
            this.inputStream.mark(262144);
        }

        @Override
        public Document readImpl(SAXReader reader) throws DocumentException {
            return reader.read(this.inputStream);
        }

        public String toString() {
            return this.inputStream.toString();
        }

        @Override
        protected XMLStreamReader getReaderImpl(XMLInputFactory inputFactory) throws XMLStreamException {
            return inputFactory.createXMLStreamReader(this.inputStream);
        }

        @Override
        protected void closeImpl() {
            try {
                this.inputStream.close();
            }
            catch (IOException e) {
                log.error("Failed to close input stream.", e);
            }
        }

        @Override
        protected void resetImpl() throws XMLStreamException {
            try {
                this.inputStream.reset();
            }
            catch (IOException e) {
                throw new XMLStreamException(e);
            }
        }

        @Override
        public Source getJavaxSourceImpl() {
            return new StreamSource(this.inputStream);
        }
    }

    private static final class UrlXmlSource
    extends XmlSource {
        private final URL url;
        private InputStream urlStream;

        public UrlXmlSource(URL url) {
            this.url = url;
        }

        @Override
        public Document readImpl(SAXReader reader) throws DocumentException {
            return reader.read(this.url);
        }

        public String toString() {
            return this.url.toString();
        }

        @Override
        protected XMLStreamReader getReaderImpl(XMLInputFactory inputFactory) throws XMLStreamException {
            try {
                this.urlStream = this.url.openStream();
                return inputFactory.createXMLStreamReader(this.urlStream);
            }
            catch (IOException e) {
                throw new XMLStreamException(e);
            }
        }

        @Override
        protected void closeImpl() {
            try {
                this.urlStream.close();
            }
            catch (IOException e) {
                log.error("Failed to close input stream for URL " + this.url.toString(), e);
            }
        }

        @Override
        protected void resetImpl() throws XMLStreamException {
            try {
                this.urlStream.close();
                this.urlStream = this.url.openStream();
            }
            catch (IOException e) {
                throw new XMLStreamException(e);
            }
        }

        @Override
        public Source getJavaxSourceImpl() {
            try {
                return new StreamSource(new File(this.url.toURI()));
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private static final class ReaderXmlSource
    extends XmlSource {
        private Reader reader;

        public ReaderXmlSource(Reader reader) {
            this.reader = reader;
        }

        @Override
        protected void closeImpl() {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                log.error("Failed to close reader.", e);
            }
        }

        @Override
        protected XMLStreamReader getReaderImpl(XMLInputFactory inputFactory) throws XMLStreamException {
            return inputFactory.createXMLStreamReader(this.reader);
        }

        @Override
        protected Document readImpl(SAXReader saxReader) throws DocumentException {
            return saxReader.read(this.reader);
        }

        public String toString() {
            return this.reader.toString();
        }

        @Override
        protected void resetImpl() throws XMLStreamException {
            try {
                this.reader.reset();
            }
            catch (IOException e) {
                throw new XMLStreamException(e);
            }
        }

        @Override
        public Source getJavaxSourceImpl() {
            return new StreamSource(this.reader);
        }
    }
}

